<?php

namespace App\Http\Controllers;

use App\Models\History;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;

class HistoryController extends Controller
{
    public function index(): JsonResponse
    {
        $histories = History::all()->map(function ($history) {
            return [
                'username' => $history->username,
                'code' => $history->code,
                'is_redeemed' => $history->is_redeemed,
                'prize' => [
                    'name' => $history->prize
                ],
            ];
        });

        return response()->json($histories);
    }
}
