<?php

namespace App\Http\Controllers;

use App\Models\Ticket;
use App\Models\History;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;

class RedeemController extends Controller
{
    public function generate(Request $request)
    {
        $request->validate([
            "username" => "required|string|max:255"
        ]);


        $ticket = Ticket::create([
            "username" => $request->username,
            "code" => $request->username,
            'is_redeemed' => false,
            'prize_id' => null,
        ]);

        return response()->json([
            'message' => 'Ticket generated successfully',
            'ticket' => $ticket
        ], 201);
    }

    public function redeem(Request $request): JsonResponse
    {
        $request->validate([
            'username' => 'required|string|max:255',
            'code' => 'required|string|exists:tickets,code',
        ]);

        $ticket = Ticket::where('code', $request->code)
            ->where('username', $request->username)
            ->first();

        if (!$ticket) {
            return response()->json(['error' => 'Tiket tidak ditemukan atau username salah.'], 404);
        }

        if ($ticket->is_redeemed) {
            return response()->json(['error' => 'Tiket ini sudah diredeem sebelumnya.'], 400);
        }

        $prize = $ticket->prize;

        $ticket->update(['is_redeemed' => true]);

        History::create([
            'username' => $ticket->username,
            'prize' => $prize->name,
            'code' => $ticket->code,
            'is_redeemed' => true,
        ]);

        return response()->json([
            'success' => true,
            'message' => 'Selamat! Anda berhasil mendapatkan hadiah.',
            'prize' => [
                'name' => $prize->name,
                'description' => $prize->description,
            ],
        ]);
    }


    public function winners(): JsonResponse
    {
        $winners = Ticket::where('is_redeemed', true)
            ->with('prize')
            ->get()
            ->map(function ($ticket) {
                return [
                    'username' => $ticket->username,
                    'prize' => [
                        'name' => $ticket->prize->name,
                        'description' => $ticket->prize->description,
                    ]
                ];
            });

        if ($winners->isEmpty()) {
            return response()->json(['message' => 'Belum ada pemenang.'], 404);
        }

        return response()->json([
            'winners' => $winners
        ]);
    }
}
