<?php

namespace Database\Seeders;

use App\Models\Prize;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class PrizeSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $prizes = [
            ['name' => '20K', 'description' => 'Hadiah uang tunai 20 ribu'],
            ['name' => '50K', 'description' => 'Hadiah uang tunai 50 ribu'],
            ['name' => '100K', 'description' => 'Hadiah uang tunai 100 ribu'],
            ['name' => '200K', 'description' => 'Hadiah uang tunai 200 ribu'],
            ['name' => '500K', 'description' => 'Hadiah uang tunai 500 ribu'],
            ['name' => 'TV', 'description' => 'Hadiah berupa TV'],
            ['name' => 'Sepeda', 'description' => 'Hadiah berupa sepeda'],
            ['name' => 'iPhone 16', 'description' => 'Hadiah berupa iPhone 16'],
        ];

        foreach ($prizes as $prize) {
            Prize::create($prize);
        }
    }
}
