<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Ticket;
use App\Models\Prize;

class TicketSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $prizes = Prize::all();

        $tickets = [
            [
                'username' => 'user1',
                'code' => 'TICKET001',
                'is_redeemed' => false,
                'prize_id' => $prizes->where('name', '20K')->first()->id,
            ],
            [
                'username' => 'user2',
                'code' => 'TICKET002',
                'is_redeemed' => false,
                'prize_id' => $prizes->where('name', '50K')->first()->id,
            ],
            [
                'username' => 'user3',
                'code' => 'TICKET003',
                'is_redeemed' => false,
                'prize_id' => $prizes->where('name', '100K')->first()->id,
            ],
            [
                'username' => 'user4',
                'code' => 'TICKET004',
                'is_redeemed' => false,
                'prize_id' => $prizes->where('name', 'TV')->first()->id,
            ],
            [
                'username' => 'user5',
                'code' => 'TICKET005',
                'is_redeemed' => false,
                'prize_id' => $prizes->where('name', 'iPhone 16')->first()->id,
            ],
        ];

        // Masukkan data tiket ke database
        foreach ($tickets as $ticket) {
            Ticket::create($ticket);
        }
    }
}
