<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\DB;
use App\Models\Prize;

class WheelsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $prizes = Prize::all();

        if ($prizes->isEmpty()) {
            return;
        }

        $items = [
            [
                'label' => '20K',
                'weight' => 2,
                'image' => 'storage/images/Rp.png',
                'imageRadius' => 0,
                'imageScale' => 0.07,
                'prize_id' => $prizes[0]->id,
            ],
            [
                'label' => '50K',
                'weight' => 2,
                'image' => 'storage/images/Rp.png',
                'imageRadius' => 0,
                'imageScale' => 0.07,
                'prize_id' => $prizes[1]->id,
            ],
            [
                'label' => '100K',
                'weight' => 2,
                'image' => 'storage/images/Rp.png',
                'imageRadius' => 0,
                'imageScale' => 0.07,
                'prize_id' => $prizes[2]->id,
            ],
            [
                'label' => '200K',
                'weight' => 2,
                'image' => 'storage/images/Rp.png',
                'imageRadius' => 0,
                'imageScale' => 0.07,
                'prize_id' => $prizes[3]->id,
            ],
            [
                'label' => '500K',
                'weight' => 2,
                'image' => 'storage/images/Rp.png',
                'imageRadius' => 0,
                'imageScale' => 0.07,
                'prize_id' => $prizes[4]->id,
            ],
            [
                'label' => 'TV',
                'weight' => 2,
                'image' => 'storage/images/TV.png',
                'imageRadius' => 0,
                'imageScale' => 0.07,
                'prize_id' => $prizes[5]->id,
            ],
            [
                'label' => 'Sepeda',
                'weight' => 2,
                'image' => 'storage/images/Bike.png',
                'imageRadius' => 0,
                'imageScale' => 0.07,
                'prize_id' => $prizes[6]->id,
            ],
            [
                'label' => 'iPhone 16',
                'weight' => 2,
                'image' => 'storage/images/iPhone16.png',
                'imageRadius' => 0,
                'imageScale' => 0.03,
                'prize_id' => $prizes[7]->id,
            ],
        ];

        try {
            DB::table('wheels')->insert($items);
        } catch (\Exception $e) {
            Log::error('Error saat menyisipkan data wheels: ' . $e->getMessage());
        }
    }
}
