'use strict';

var jsxRuntime = require('react/jsx-runtime');
var React = require('react');
var tailwindMerge = require('tailwind-merge');
var mergeDeep = require('../../helpers/merge-deep.cjs');
var index = require('../../theme-store/index.cjs');
var Button = require('./Button.cjs');

const processChildren = (children, outline, pill) => {
  return React.Children.map(children, (child, index) => {
    if (React.isValidElement(child)) {
      const positionInGroupProp = child.type == Button.Button ? { positionInGroup: determinePosition(index, React.Children.count(children)) } : {};
      if (child.props.children) {
        return React.cloneElement(child, {
          ...child.props,
          children: processChildren(child.props.children, outline, pill),
          ...positionInGroupProp
        });
      } else {
        return React.cloneElement(child, {
          outline,
          pill,
          ...positionInGroupProp
        });
      }
    }
    return child;
  });
};
const determinePosition = (index, totalChildren) => {
  return index === 0 ? "start" : index === totalChildren - 1 ? "end" : "middle";
};
const ButtonGroup = ({
  children,
  className,
  outline,
  pill,
  theme: customTheme = {},
  ...props
}) => {
  const items = React.useMemo(() => processChildren(children, outline, pill), [children, outline, pill]);
  const theme = mergeDeep.mergeDeep(index.getTheme().buttonGroup, customTheme);
  return /* @__PURE__ */ jsxRuntime.jsx("div", { className: tailwindMerge.twMerge(theme.base, className), role: "group", ...props, children: items });
};
ButtonGroup.displayName = "Button.Group";

exports.ButtonGroup = ButtonGroup;
//# sourceMappingURL=ButtonGroup.cjs.map
