'use strict';

var cloneDeep = require('../helpers/clone-deep.cjs');
var mergeDeep = require('../helpers/merge-deep.cjs');
var theme = require('../theme.cjs');

const store = {
  theme: cloneDeep.cloneDeep(theme.theme)
};
function setThemeMode(mode) {
  store.mode = mode;
}
function getThemeMode() {
  return store.mode;
}
function setTheme(theme$1) {
  if (theme$1) store.theme = mergeDeep.mergeDeep(theme.theme, theme$1);
}
function getTheme() {
  return cloneDeep.cloneDeep(store.theme);
}

exports.getTheme = getTheme;
exports.getThemeMode = getThemeMode;
exports.setTheme = setTheme;
exports.setThemeMode = setThemeMode;
//# sourceMappingURL=index.cjs.map
