import { ReactNode, CSSProperties, FC, RefAttributes } from "react";
import "./Marquee.scss";
export declare type MarqueeProps = {
    /**
     * @description Inline style for the container div
     * @type {CSSProperties}
     * @default {}
     */
    style?: CSSProperties;
    /**
     * @description Class name to style the container div
     * @type {string}
     * @default ""
     */
    className?: string;
    /**
     * @description Whether to automatically fill blank space in the marquee with copies of the children or not
     * @type {boolean}
     * @default false
     */
    autoFill?: boolean;
    /**
     * @description Whether to play or pause the marquee
     * @type {boolean}
     * @default true
     */
    play?: boolean;
    /**
     * @description Whether to pause the marquee when hovered
     * @type {boolean}
     * @default false
     */
    pauseOnHover?: boolean;
    /**
     * @description Whether to pause the marquee when clicked
     * @type {boolean}
     * @default false
     */
    pauseOnClick?: boolean;
    /**
     * @description The direction the marquee is sliding
     * @type {"left" | "right" | "up" | "down"}
     * @default "left"
     */
    direction?: "left" | "right" | "up" | "down";
    /**
     * @description Speed calculated as pixels/second
     * @type {number}
     * @default 50
     */
    speed?: number;
    /**
     * @description Duration to delay the animation after render, in seconds
     * @type {number}
     * @default 0
     */
    delay?: number;
    /**
     * @description The number of times the marquee should loop, 0 is equivalent to infinite
     * @type {number}
     * @default 0
     */
    loop?: number;
    /**
     * @description Whether to show the gradient or not
     * @type {boolean}
     * @default false
     */
    gradient?: boolean;
    /**
     * @description The color of the gradient
     * @type {string}
     * @default "white"
     */
    gradientColor?: string;
    /**
     * @description The width of the gradient on either side
     * @type {number | string}
     * @default 200
     */
    gradientWidth?: number | string;
    /**
     * @description A callback for when the marquee finishes scrolling and stops. Only calls if loop is non-zero.
     * @type {() => void}
     * @default null
     */
    onFinish?: () => void;
    /**
     * @description A callback for when the marquee finishes a loop. Does not call if maximum loops are reached (use onFinish instead).
     * @type {() => void}
     * @default null
     */
    onCycleComplete?: () => void;
    /**
     * @description: A callback function that is invoked once the marquee has finished mounting. It can be utilized to recalculate the page size, if necessary.
     * @type {() => void}
     * @default null
     */
    onMount?: () => void;
    /**
     * @description The children rendered inside the marquee
     * @type {ReactNode}
     * @default null
     */
    children?: ReactNode;
} & RefAttributes<HTMLDivElement>;
declare const Marquee: FC<MarqueeProps>;
export default Marquee;
