import React from "react";
import axios from "axios";
import ReactDOM from "react-dom/client";
import { createBrowserRouter, RouterProvider } from "react-router-dom";
import { Provider } from "react-redux";
import store from "./store";
import Home from "./pages/Home";
import Login from "./pages/Login";
import Operator from "./pages/operator/Operator";
import Generate from "./pages/operator/Genrate";
import WheelSpin from "./pages/operator/WheelSpin";
import Settings from "./pages/operator/Settings";
import PrivateRoute from "./components/PrivateRoute";
import "../css/app.css";

axios.defaults.baseURL = import.meta.env.VITE_API_URL;
axios.defaults.withCredentials = true;

const router = createBrowserRouter([
    {
        path: "/",
        element: <Home />,
    },
    {
        path: "/login",
        element: <Login />,
    },
    {
        path: "/operator",
        element: <PrivateRoute element={<Operator />} />,
        children: [
            {
                path: "generate",
                element: <PrivateRoute element={<Generate />} />,
            },
            {
                path: "wheel",
                element: <PrivateRoute element={<WheelSpin />} />,
            },
            {
                path: "settings",
                element: <PrivateRoute element={<Settings />} />,
            },
        ],
    },
]);

ReactDOM.createRoot(document.getElementById("app") as HTMLElement).render(
    <Provider store={store}>
        <RouterProvider router={router} />
    </Provider>
);
