import React, { useEffect, useState } from "react";
import { Navigate } from "react-router-dom";
import { useDispatch, useSelector } from "react-redux";
import { RootState } from "../store";
import { checkToken } from "../store/authSlice";

interface PrivateRouteProps {
    element: JSX.Element;
}

const PrivateRoute: React.FC<PrivateRouteProps> = ({ element }) => {
    const dispatch = useDispatch();
    const token = useSelector((state: RootState) => state.auth.token);

    useEffect(() => {
        const verifyToken = async () => {
            await dispatch(checkToken());
        };

        verifyToken();
    }, [dispatch]);

    if (!token) {
        return <Navigate to="/login" />;
    }

    return element;
};

export default PrivateRoute;
