const pi = Math.PI;
const tau = 2 * Math.PI;
const amplitude = 1;
const period = 0.3;

function tpmt(x: number) {
    return (Math.pow(2, -10 * x) - 0.0009765625) * 1.0009775171065494;
}

export function sinInOut(t: number) {
    return (1 - Math.cos(pi * t)) / 2;
}

export function cubicOut(t: number) {
    return --t * t * t + 1;
}

export function cubicInOut(t: number) {
    return ((t *= 2) <= 1 ? t * t * t : (t -= 2) * t * t + 2) / 2;
}

export const elasticInOut = (function custom(a: number, p: number) {
    const s = Math.asin(1 / (a = Math.max(1, a))) * (p /= tau);

    function elasticInOut(t: number) {
        return (
            ((t = t * 2 - 1) < 0
                ? a * tpmt(-t) * Math.sin((s - t) / p)
                : 2 - a * tpmt(t) * Math.sin((s + t) / p)) / 2
        );
    }

    elasticInOut.amplitude = function (a: number) {
        return custom(a, p * tau);
    };
    elasticInOut.period = function (p: number) {
        return custom(a, p);
    };

    return elasticInOut;
})(amplitude, period);

export function bounceOut(t: number) {
    const b1 = 4 / 11,
        b2 = 6 / 11,
        b3 = 8 / 11,
        b4 = 3 / 4,
        b5 = 9 / 11,
        b6 = 10 / 11,
        b7 = 15 / 16,
        b8 = 21 / 22,
        b9 = 63 / 64,
        b0 = 1 / b1 / b1;

    return (t = +t) < b1
        ? b0 * t * t
        : t < b3
        ? b0 * (t -= b2) * t + b4
        : t < b6
        ? b0 * (t -= b5) * t + b7
        : b0 * (t -= b8) * t + b9;
}
