async function LoadImages(images: HTMLImageElement[]): Promise<void> {
    const promises = images.map((img) => img.decode());

    try {
        await Promise.all(promises);
    } catch (error) {
        throw new Error("An image could not be loaded");
    }
}

export default LoadImages;
