import React, { useState } from "react";
import { Outlet, Link, useLocation } from "react-router-dom";
import { useDispatch } from "react-redux";
import { logout } from "../../store/authSlice";

import { PiSpinnerBallFill } from "react-icons/pi";
import { RiUserSettingsFill } from "react-icons/ri";
import { FaTicketAlt } from "react-icons/fa";
import { FaBars, FaTimes } from "react-icons/fa";

const OperatorLayout: React.FC = () => {
    const dispatch = useDispatch();
    const location = useLocation();
    const [isSidebarOpen, setIsSidebarOpen] = useState(false);

    const handleLogout = () => {
        dispatch(logout());
    };

    const toggleSidebar = () => {
        setIsSidebarOpen(!isSidebarOpen);
    };

    return (
        <div className="flex h-screen bg-gray-100">
            {/* Hamburger Button for Mobile */}
            <button
                className="md:hidden fixed top-4 left-4 z-50 text-white bg-gray-800 p-2 rounded focus:outline-none"
                onClick={toggleSidebar}
            >
                {isSidebarOpen ? (
                    <FaTimes className="text-2xl" />
                ) : (
                    <FaBars className="text-2xl" />
                )}
            </button>

            {/* Sidebar */}
            <aside
                className={`fixed top-0 left-0 h-full bg-gray-800 text-white p-4 transition-transform transform md:translate-x-0 ${
                    isSidebarOpen ? "translate-x-0" : "-translate-x-full"
                } md:w-64 w-64 z-40`}
            >
                <Link to="/operator">
                    <h2 className="text-2xl font-semibold mb-4">Dashboard</h2>
                </Link>
                <ul className="space-y-2">
                    <li>
                        <Link
                            to="/operator/generate"
                            className="flex items-center px-4 py-2 hover:bg-gray-700 rounded"
                        >
                            <FaTicketAlt className="me-2 text-xl" />
                            Generate Code
                        </Link>
                    </li>
                    <li>
                        <Link
                            to="/operator/wheel"
                            className="flex items-center px-4 py-2 hover:bg-gray-700 rounded"
                        >
                            <PiSpinnerBallFill className="me-2 text-xl" />
                            Wheel Spin
                        </Link>
                    </li>
                    <li>
                        <Link
                            to="/operator/settings"
                            className="flex items-center px-4 py-2 hover:bg-gray-700 rounded"
                        >
                            <RiUserSettingsFill className="me-2 text-xl" />
                            User Setting
                        </Link>
                    </li>
                </ul>
                <button
                    onClick={handleLogout}
                    className="w-full mt-4 bg-red-600 text-white py-2 rounded hover:bg-red-700"
                >
                    Logout
                </button>
            </aside>

            {/* Overlay for Mobile */}
            {isSidebarOpen && (
                <div
                    className="fixed inset-0 bg-black opacity-50 z-30 md:hidden"
                    onClick={toggleSidebar}
                ></div>
            )}

            {/* Main Content */}
            <div className="flex-1 md:ml-64 p-6">
                {/* Page Content */}
                {location.pathname === "/operator" ||
                location.pathname === "/operator/" ? (
                    <div className="py-8 px-4 mx-auto max-w-screen-xl text-center lg:py-16">
                        <h1 className="mb-4 text-4xl font-extrabold tracking-tight leading-none text-gray-900 md:text-5xl lg:text-6xl dark:text-white">
                            Welcome to Dashboard
                        </h1>
                        <p className="mb-8 text-lg font-normal text-gray-500 lg:text-xl sm:px-16 lg:px-48 dark:text-gray-400">
                            Lorem ipsum dolor sit amet consectetur adipisicing
                            elit. Vitae officia quaerat, ipsam architecto quidem
                            doloribus itaque fuga deleniti pariatur numquam
                            delectus natus quos sit voluptatem excepturi
                            quibusdam, officiis cum sequi?
                        </p>
                    </div>
                ) : (
                    <main>
                        <Outlet />
                    </main>
                )}
            </div>
        </div>
    );
};

export default OperatorLayout;
