<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\PrizeController;
use App\Http\Controllers\WheelController;
use App\Http\Controllers\RedeemController;
use App\Http\Controllers\TicketController;
use App\Http\Controllers\HistoryController;

Route::post('/register', [AuthController::class, 'register']);
Route::post('/login', [AuthController::class, 'login']);

Route::apiResource('wheels', WheelController::class);
Route::apiResource("/prize", PrizeController::class);
Route::post("/redeem", [RedeemController::class, 'redeem']);
Route::post("/generate", [RedeemController::class, "generate"]);
Route::get("/winners", [RedeemController::class, 'winners']);

Route::middleware('auth:sanctum')->group(function () {
  Route::post('/logout', [AuthController::class, 'logout']);
  Route::get('/me', [AuthController::class, 'me']);
  Route::apiResource('ticket', TicketController::class);
  Route::get('/history', [HistoryController::class, 'index']);

  Route::apiResource('/users', UserController::class);
});
